 ; Ŀ
 ;   Doon - insert a conduit down block on a line, adjust the line.        
 ;   Copyright 1995, 2010 by Rocket Software Ltd.                          
 ;   The Scottish doon, not the American one.                              
 ; 

 ; Ŀ
 ;   Condor - error handler.                                               
 ; 
 (DEFUN CONDOR (shk)
  (setq *error* esav)
  (if clay (setvar "clayer" clay))
  (if blip (setvar "blipmode" blip))
  (if (/= shk "Function cancelled") (write-line shk))
 (princ))
 ; Ŀ
 ;   Condor end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Angpt - find the inside angle indicated by three points.   
 ;   Takes the two line endpoints and the intersection as arguments,       
 ;   returns a list: the inside angle in radians and degrees.              
 ; 
 (DEFUN ANGPT (pta ptcom ptb / ang1 ang2 angg)
  (setq ang1 (angle ptcom pta))
  (setq ang2 (angle ptcom ptb))
  (if (> ang1 ang2)
      (setq angg (- ang1 ang2))
      (setq angg (- ang2 ang1)))
  (if (> angg pi)
      (setq angg (abs (- angg (* 2 pi)))))
  (list angg (/ (* 180 angg) pi)))         ; radians and degrees
 ; Ŀ
 ;   Angpt end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Linr: deduce which end of a line is nearest to a point,    
 ;   change it to the point, return the line angle in degrees.             
 ; 
 (DEFUN LINR (pa end1 end2 / far near)
  (if (> (distance pa end1) (distance pa end2))
      (progn
           (setq far end1 near end2)
           (entmod (subst (cons 11 pa) (cons 11 near) entt)))
      (progn
           (setq near end1 far end2)
           (entmod (subst (cons 10 pa) (cons 10 near) entt))))
  (setq rota (angle near far))
  (setq rrota (/ (* 180 rota) pi)))
 ; Ŀ
 ;   Linr end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Spitt: see if a point lies on a line.  Sucks in two        
 ;   arguments, the point and the endpoints of the line, and returns T     
 ;   if the point is on the line and () otherwise.                         
 ; 
 (DEFUN SPITT (pa linp1 linp2 / ang1 p2 inter1)
 ; Ŀ
 ;   Find the line angle.                                                  
 ; 
  (setq ang1 (angle linp1 linp2))
 ; Ŀ
 ;   Find the endpoint of a theoretical line starting at pa and            
 ;   perpendicular to the line described by the two endpoint arguments.    
 ; 
  (setq p2 (polar pa (+ ang1 (/ pi 2)) 10))
 ; Ŀ
 ;   Now find the intersection of the two.                                 
 ; 
  (setq inter1 (inters linp1 linp2 pa p2))
 ; Ŀ
 ;   If the two intersect and the intersection is at pa, then pa is on     
 ;   the line.                                                             
 ; 
  (if (and inter1 (equal pa inter1 0.0000001)) T ()))
 ; Ŀ
 ;   Spitt end.                                                            
 ; 

 ; Ŀ
 ;   Doon - Lorna's program.                                               
 ; 
 (DEFUN C:DOON (/ blip clay scal cutdis pa prim typ1 entt prim2 typ2 entt2
                  end1 end2 c3 d4 ang2 b1 b2 modlst anend newend asoc end10
                                          end11 near linang insang diff rrr)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq clay (getvar "clayer"))
  (setq esav *error*)
  (setq *error* condor)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq scal (misps))
  (setq cutdis (* scal 1.5))               ; radius of the block
  (setq pa (getpoint "\nInsertion point/Upper line: "))
  (setq prim (ssget pa))
  (if prim (setq prim (ssname prim 0)))
  (if prim (setq typ1 (cdr (assoc 0 (setq entt (entget prim))))))
  (if (= typ1 "LINE") (setq prim2 (entsel "\nLower line or <Return>: ")))
  (if prim2 (setq typ2 (cdr (assoc 0 (setq entt2 (entget (car prim2)))))))
 ; Ŀ
 ;   If two lines were picked:                                             
 ; 
  (cond ((= typ2 "LINE")
         (setq end1 (cdr (assoc 10 entt)))
         (setq end2 (cdr (assoc 11 entt)))
         (setq c3 (cdr (assoc 10 entt2)))
         (setq d4 (cdr (assoc 11 entt2)))
         (if (setq pa (inters end1 end2 c3 d4 ()))
             (progn
 ; Ŀ
 ;   Modify the primary line, get the block insertion angle.               
 ; 
                  (linr pa end1 end2)
 ; Ŀ
 ;   If the intersection of the two lines lies on the second one, want     
 ;   to break it to accommodate the block.                                 
 ; 
                  (if (spitt pa c3 d4)
                      (progn
                           (setq ang2 (angle c3 d4))
                           (setq b1 (polar pa ang2 cutdis))
                           (setq b2 (polar pa ang2 (- cutdis)))
                           (command "break" prim2 "f" b1 b2))
 ; Ŀ
 ;   If the lines don't intersect, change the near end of the secondary    
 ;   line to meet the near side of the block.                              
 ; 
                      (progn
                           (setq ang2 (angle c3 d4))
 ; Ŀ
 ;   Find the closest end of the line to the block insertion Pa.           
 ; 
                           (if (< (distance pa c3) (distance pa d4))
                               (setq modlst (setq anend (assoc 10 entt2)))
                               (setq modlst (setq anend (assoc 11 entt2))))
 ; Ŀ
 ;   And find the side of the block closest to the near line end.          
 ; 
                           (setq newend (polar pa (angle pa (cdr anend))
                                                                      cutdis))
 ; Ŀ
 ;   Modify the line.                                                      
 ; 
                           (setq asoc (car modlst))
                           (entmod (subst (cons asoc newend) modlst entt2)))))
             (write-line "\nThose lines are parallel, ninny.")))
 ; Ŀ
 ;   If only one line was picked:                                          
 ;   Want to chop a hole in the line and insert the block.  Must ask for   
 ;   a block angle, offering the angle as default which would orient the   
 ;   block toward the nearest end.                                         
 ;   Note that there is no need to extend the line: it has to reach the    
 ;   block to have been selected.                                          
 ; 
        ((= typ1 "LINE")
         (setq pb (osnap pa "Nearest"))
         (if pb (setq pa pb))
         (setq end10 (cdr (assoc 10 entt)))
         (setq end11 (cdr (assoc 11 entt)))
 ; Ŀ
 ;   Find the angle towards the closest end, offer it as the default,      
 ;   get a point indicating toward which end to face the block.            
 ; 
         (if (< (distance pa end10) (distance pa end11))
             (setq rrota (angle end10 end11))
             (setq rrota (angle end11 end10)))
         (setq inspt (getpoint pa (strcat "\nGeneral open side direction <"
                                   (rtos (/ (* 180 rrota) pi) 2 2) ">: ")))
 ; Ŀ
 ;   If a point Inspt was chosen, call Ang to see which end it was angled  
 ;   towards.                                                              
 ; 
         (if inspt
             (progn
                  (setq ang10 (car (angpt inspt pa end10)))
                  (setq ang11 (car (angpt inspt pa end11)))
                  (if (> ang10 ang11)
                      (setq rrota (angle end10 end11))
                      (setq rrota (angle end11 end10)))))
 ; Ŀ
 ;   The line must be broken on one side or another of the insertion       
 ;   point at either + or - the line angle, depending on the block angle.  
 ; 
         (setq b2 (polar pa (+ pi rrota) cutdis)) ; find second breakpt
         (command "break" prim pa b2)             ; break the line
         (setq rrota (/ (* 180 rrota) pi)))       ; convert rrota to degrees
 ; Ŀ
 ;   The default Cond: no lines were picked.                               
 ; 
        (T
         (if (/= (type rrota) 'REAL) (setq rrota 0.0))
         (setq rrr (getangle pa (strcat "\nInsertion angle <"
                                          (rtos rrota 2 2) ">: ")))
         (if rrr (setq rrota (/ (* 180 rrr) pi)))))
 ; Ŀ
 ;   Save the current layer name, make Eequip the new current one.         
 ; 
  (if (tblsearch "layer" "eequip")
      (setvar "clayer" "eequip")
      (command "layer" "m" "eequip" ""))
 ; Ŀ
 ;   Now insert the block:                                                 
 ; 
  (if pa (command "insert" "condown" pa scal "" (+ rrota 180)))
 ; Ŀ
 ;   Reset and end.                                                        
 ; 
  (setvar "clayer" clay)
  (setvar "blipmode" blip)
  (setq *error* esav)
 (princ))